#!/bin/bash

# Determine Linux Distro and Version
. /etc/os-release

linux_ver=${VERSION_ID:0:2}

# apt-get installs
echo "Installing dependencies..."
apt-get install -y libqt5webkit5 > /dev/null
apt-get install -y resolvconf > /dev/null
apt-get install -y wmctrl  > /dev/null 2>&1

echo "Installing Gnome extensions..."
if [ $linux_ver == 20 ]; then
    echo "Installing Gnome extensions..."
    apt-get install -y gnome-tweak-tool
    apt-get install -y gnome-shell-extension-appindicator
    apt-get install -y gnome-shell-extension-top-icons-plus
elif [ $linux_ver == 22 ]; then
    echo "Installing Gnome extensions..."
    apt-get install -y gnome-shell-extension-manager
    apt-get install -y gnome-shell-extension-appindicator
fi
